/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import panther.util.general.ErrorUtils;

public class ProcessBufferingThread
extends Thread {
    protected InputStream rawInput;
    protected StringBuilder builder;
    protected boolean done = false;
    protected boolean readDone = false;

    public ProcessBufferingThread(InputStream inputStream, StringBuilder stringBuilder) {
        this.rawInput = inputStream;
        this.builder = stringBuilder;
    }

    public void beDone() {
        this.done = true;
        this.interrupt();
    }

    public boolean isReadDone() {
        return this.readDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        InputStreamReader inputStreamReader = new InputStreamReader(this.rawInput);
        char[] cArray = new char[20000];
        try {
            while (!this.done && !this.readDone) {
                try {
                    int n = inputStreamReader.read(cArray, 0, 20000);
                    if (n > 0) {
                        this.builder.append(cArray, 0, n);
                        continue;
                    }
                    if (n >= 0) continue;
                    this.readDone = true;
                }
                catch (IOException iOException) {
                    ErrorUtils.check(iOException);
                    this.readDone = true;
                }
                catch (Throwable throwable) {
                    ErrorUtils.check(throwable);
                }
            }
            return;
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Throwable throwable) {
                    ErrorUtils.check(throwable);
                }
            }
        }
    }
}

